#!/bin/bash
sdir=/usr/share/omix
ldir=/var/lib/omix
vdir=/etc/omix

apply_shell_expansion() {
    declare file="$1"
    declare data=$(< "$file")
    declare delimiter="__apply_shell_expansion_delimiter__"
    declare command="cat <<$delimiter"$'\n'"$data"$'\n'"$delimiter"
    eval "$command"
}

getvar() {
    sed '/^#/d; /^[ \t]*$/d' $vdir/$1
}

export sdir ldir vdir
export -f getvar

shopt -s  nullglob
for i in $sdir/includes/*; do
  . $i
done

run() {
    [[ $1 == t ]] && local dir=$sdir/template fn=apply_shell_expansion
    [[ $1 == s ]] && local dir=$sdir/script   fn=
    [[ -z $dir ]] && return
    for file in $(find $dir -type f | sed "s,$dir/,,"); do
        mkdir -p $ldir/$(dirname $file)
        $fn $dir/$file  >$ldir/$file
    done
}

defaultvars=$(echo /usr/share/omix/defaultvars/*)
[[ -n $defaultvars ]] && cp -n -t /etc/omix $defaultvars

run t
run s

run-parts $sdir/reload
exit
