#!/bin/bash

PIDFILE="/tmp/my_task.pid"

# Функція, яку ми хочемо запустити
my_background_task() {
    # Імітація роботи
    for i in {1..30}; do
        echo "Працюю: $i" >> /tmp/task_log.txt
        sleep 1
    done
    rm -f "$PIDFILE"
}

# Перевірка статусу
if [ -f "$PIDFILE" ]; then
    PID=$(cat "$PIDFILE")
    if ps -p "$PID" > /dev/null 2>&1; then
        echo "Процес вже запущений (PID: $PID)"
        exit 0
    else
        echo "PID-файл є, але процес мертвий. Очищую..."
        rm -f "$PIDFILE"
    fi
fi

# Запуск функції як демона
echo "Запускаю фоновий процес..."
# ( ... ) & запускає підпроцес, 
# <&- >&- 2>&- закриває стандартні потоки, щоб Bash не чекав їх закриття
( my_background_task ) <&- >&- 2>&- & 

# Зберігаємо PID
echo $! > "$PIDFILE"

echo "Скрипт завершує роботу, процес працює в фоні."
exit 0
