# pvmzync - Proxmox VM ZFS Sync Tools

Suite of tools for Proxmox VE virtual machine migration and backup using ZFS replication.

## Packages

### pvmzync-common
Core library and utilities:
- **zynclib**: ZFS synchronization library with resume support
- **zynalyz**: Transfer log analyzer with live statistics

### pvmzync-mig  
VM migration tool (`pvmig`) for moving VMs between Proxmox hosts.

### pvmzync-zup
VM backup tool (`pvmzup`) for backing up VMs to remote ZFS storage.

## Building

### Prerequisites
```bash
sudo apt-get install debhelper devscripts
```

### Build all packages
```bash
cd pvmzync
dpkg-buildpackage -us -uc
```

This will create in parent directory:
- `pvmzync-common_1.0.0-1_all.deb`
- `pvmzync-mig_1.0.0-1_all.deb`
- `pvmzync-zup_1.0.0-1_all.deb`
- `pvmzync_1.0.0-1.dsc`

## Installation

```bash
# Install common library (required)
sudo dpkg -i pvmzync-common_1.0.0-1_all.deb
sudo apt-get install -f  # Install dependencies

# Install migration tool
sudo dpkg -i pvmzync-mig_1.0.0-1_all.deb

# Install backup tool  
sudo dpkg -i pvmzync-zup_1.0.0-1_all.deb
```

## Usage

### Migration
```bash
pvmig 100 source-host dest-host
```

### Backup
```bash
pvmzup -o client1 100 backup-server
```

### Live Statistics
During transfer, view progress:
```bash
kill -USR1 $(pidof pvmig)
# or
kill -USR1 $(pidof pvmzup)
```

## Files

### pvmzync-common
- `/usr/lib/pvmzync/zynclib` - Core library
- `/usr/lib/pvmzync/zynalyz` - Log analyzer
- `/etc/pvmzync/` - Configuration directory
- `/var/run/pvmzync/` - Runtime data
- `/var/log/pvmzync/` - Log files

### pvmzync-mig
- `/usr/bin/pvmig` - Migration tool

### pvmzync-zup
- `/usr/bin/pvmzup` - Backup tool

## Dependencies

- `zfsutils-linux` - ZFS utilities
- `mbuffer` - Network buffering
- `bc` - Calculator for statistics
- `coreutils` (>= 8.0) - For numfmt
- `openssh-client` - SSH client

## License

GPL-3+

## Author

Andrew Golubev <golubev@svami.in.ua>
